/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.mimicer.entities.goals;

import de.cadentem.mimicer.entities.MimicerEntity;
import de.cadentem.mimicer.entities.goals.Roll;
import de.cadentem.mimicer.util.Utils;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class MimicerStareGoal
extends Goal {
    private final MimicerEntity mimicer;
    private boolean wasNotLookingPreviously;
    private int lookedAtCount;
    private final int lookedAtMax;

    public MimicerStareGoal(MimicerEntity mimicer) {
        this.mimicer = mimicer;
        this.lookedAtMax = mimicer.m_217043_().m_216332_(4, 13);
    }

    public boolean m_8036_() {
        if (this.mimicer.m_20145_()) {
            return false;
        }
        if (!Utils.isValidTarget((Entity)this.mimicer.m_5448_())) {
            return false;
        }
        return this.mimicer.currentRoll == Roll.STARE;
    }

    public boolean m_8045_() {
        if (!Utils.isValidTarget((Entity)this.mimicer.m_5448_())) {
            return false;
        }
        return this.mimicer.currentRoll == Roll.STARE;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        super.m_8041_();
        this.lookedAtCount = 0;
        this.wasNotLookingPreviously = false;
        this.mimicer.pleaseStopMoving = false;
        this.mimicer.setSpotted(false);
    }

    public void m_8037_() {
        boolean actuallyLooking;
        LivingEntity target = this.mimicer.m_5448_();
        if (target == null) {
            this.mimicer.disappear();
            return;
        }
        boolean bl = actuallyLooking = this.mimicer.targetIsFacingMe && target.m_142582_((Entity)this.mimicer);
        if (this.wasNotLookingPreviously && actuallyLooking) {
            ++this.lookedAtCount;
        }
        if (this.lookedAtCount > this.lookedAtMax) {
            if (!actuallyLooking && this.mimicer.m_217043_().m_188500_() < 0.1) {
                this.mimicer.disappear();
            } else if (this.mimicer.m_217043_().m_188500_() < 0.3) {
                this.mimicer.pickRoll(List.of(Roll.CHASE, Roll.FLEE));
            }
        }
        if (!actuallyLooking) {
            this.mimicer.pleaseStopMoving = false;
            this.mimicer.m_21573_().m_5624_((Entity)target, 1.0);
        } else {
            this.mimicer.pleaseStopMoving = true;
            this.mimicer.m_21573_().m_26573_();
            this.mimicer.m_20256_(Vec3.f_82478_);
        }
        this.mimicer.m_21563_().m_148051_((Entity)target);
        this.wasNotLookingPreviously = !actuallyLooking;
    }
}

